/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.fmtwidgets.ListBuilder;
import com.quantumdata.fmteditor.report.FmtTable;
import com.quantumdata.fmteditor.report.FmtTableModel;
import com.quantumdata.widgets.QDListItem;
import javax.swing.table.TableColumnModel;

public class ColumnBuilder
extends ListBuilder {
    private FmtTable m_table;
    private CmdValue m_name;

    public ColumnBuilder(FmtTable fmtTable) {
        this.m_table = fmtTable;
        this.setPickTitle("Column Choices");
        this.setBuildTitle("Columns in the Table");
        this.init();
    }

    public void configureTable() {
        this.m_table.getData().clear();
        this.m_table.getData().clearColumns();
        int n = this.getBuildCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnItem columnItem = (ColumnItem)this.getBuildItem(i);
            if (columnItem.getValue() != this.m_name) {
                this.m_table.getData().addColumn(columnItem.getValue().getName());
                continue;
            }
            n2 = i;
        }
        if (n2 != 0) {
            TableColumnModel tableColumnModel = this.m_table.getColumnModel();
            tableColumnModel.moveColumn(0, n2);
        }
    }

    private void init() {
        Format format = this.m_table.getData().getReferenceFormat();
        for (CmdValue object2 : format.getValues()) {
            if (object2.isObsolete()) continue;
            this.addPickItem(new ColumnItem(object2));
        }
        this.m_name = new CmdValue("Name", CmdValueType.INT, "", 0.0, "Format Name");
        ColumnItem columnItem = new ColumnItem(this.m_name);
        columnItem.setRemoveable(false);
        columnItem.setMarked(true);
        this.addBuildItem(columnItem);
        FmtTableModel fmtTableModel = this.m_table.getData();
        for (CmdValue cmdValue : fmtTableModel.getColumnValues()) {
            this.addBuildItem(new ColumnItem(cmdValue));
        }
        int n = this.m_table.convertColumnIndexToView(0);
        if (n > 0) {
            this.selectBuildItem(0);
            while (n > 0) {
                super.moveSelected(columnItem, false);
                --n;
            }
        }
    }

    protected void addSelected(QDListItem qDListItem) {
        ColumnItem columnItem = (ColumnItem)qDListItem;
        ColumnItem columnItem2 = new ColumnItem(columnItem.getValue());
        this.addBuildItem(columnItem2);
    }

    protected boolean itemDropped(String string, int n) {
        ColumnItem columnItem = (ColumnItem)((Object)this.m_pickList.getItem(string));
        if (columnItem == null) {
            return false;
        }
        ColumnItem columnItem2 = new ColumnItem(columnItem.getValue());
        this.addBuildItem(columnItem2, n);
        return true;
    }

    private class ColumnItem
    extends QDListItem {
        private CmdValue m_value;
        private boolean m_removable;

        public ColumnItem(CmdValue cmdValue) {
            super("");
            this.m_removable = true;
            this.m_value = cmdValue;
            this.updateText();
        }

        public void setRemoveable(boolean bl) {
            this.m_removable = bl;
        }

        public boolean isRemoveable() {
            return this.m_removable;
        }

        private void updateText() {
            String string = "";
            if (this.m_value.getCmd().length() > 0) {
                string = this.m_value.getCmd() + ": ";
            }
            string = string + this.m_value.getDescription();
            this.setText(string);
        }

        public CmdValue getValue() {
            return this.m_value;
        }
    }
}

